\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 20))
  markup-system-spacing = #'((basic-distance . 20))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
  %system-count = #3
}

\header {
  title = "Sărutul păcii"
  subtitle = "Şi duhului...  Pe Tatăl..."
  composer = "arm. după N. Lungu" 
  %meter = " "
  tagline=""
}

global = {
  \key f \major
  \time 2/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
  %\autoBeamOff
}

womenWords = \lyricmode {
  Şi du -- hu -- lui tău.
	
  Pe Ta -- tăl, pe Fi -- ul şi pe Sfân -- tul Duh, __
  Tre -- i -- mea cea de o __ fi -- in -- ţă
  şi ne -- des -- păr -- ţi -- tă.
}

menWords = \lyricmode {
  Şi du -- hu -- lui tău.	
  Pe Ta -- tăl, pe Fi -- ul şi pe Sfân -- tul Duh, __
  Tre -- i -- mea cea de o fi -- in -- ţă
  şi ne -- des -- păr -- ţi -- tă.
}

sopMusic = \relative c' {
  %\mark "                  Şi duhului tău"
  %\override Lyrics.LyricSpace.minimum-distance = #2.0
  %\override Lyrics.LyricHyphen.minimum-distance = #1.0
  f4^\mf a2 g4 g f2 \bar "||"   
  %\mark "            Pe Tatăl"
  \partial 4 c4^\mf
  f2 f4 f4 g4 g4 f4 e4 f4 g4 a2( a8) h8\rest
  a4 f'2 e2 
  d4 c4 b8([ a8]) g4 c8([ b a8 b8)] a2
  f4 f4 g4 g4 a4( g4 f4 e4) d2
  \bar "|."
}

altMusic = \relative c' {
  f4 f2 e4 e f2
  c4 f2 f4 f4 e e f4 e4 d e f2( f8) h8\rest
  a4 a( c) c2 b4 a g8([ f]) e4 a8([ g f g]) f2
  f4 f e e f( e d cis) d2
}

tenorMusic = \relative c {
  f4 f2 g4 g a2
  c,4 f2 f4 f g g f g a b c2( c8)
  d,8\rest d4\rest d2\rest d4\rest
  a'4 b a g8 a b c c4( d) c2
  d,4 d e e f2( f) d
}

bassMusic = \relative c {
  f4 f2 c4 c <f f,>2	
  c4 f2 f4 f c c d a d c f2( f8)
  d8\rest d4\rest d2\rest d4\rest
  a'4 b a g8 a b c a([ g f c]) f2
  d4 d c c f( e d \tuplet 3/2 { a8[ b cis]) } d2
  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altMusic }
      >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

midiOutput = \midi {
   \tempo 4 = 80
   \context { \Voice \remove "Dynamic_performer" }
}

\book {

 \score {
  \myScore
  \layout { }
  \midi { \midiOutput }
 }

 \score {
  %\unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
 }
 
 \score {
  %\unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
 }

\score {
  %\unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
 }

 \score {
  %\unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
 }
 
\markup {
    \large {
      \vspace #2.0
      \fill-line { \line \bold \huge { Crezul } }
    } 
 }

\markup {
    \large {
     \vspace #2.0
     \column {
     	"Cred întru Unul Dumnezeu, Tatăl Atotţiitorul,"
         "Făcătorul cerului şi al pământului, al tuturor celor văzute și nevăzute."
         "Şi întru Unul Domn Iisus Hristos, Fiul lui Dumnezeu,"
         "Unul Născut, Care din Tatăl S-a născut, mai înainte de toţi vecii." 
         "Lumină din Lumină, Dumnezeu adevărat din Dumnezeu adevărat, născut iar nu făcut; "
         "Cel de o fiinţă cu Tatăl, prin Care toate s-au făcut."
         "Care pentru noi, oamenii, şi pentru a noastră mântuire," 
         "S-a pogorât din ceruri şi S-a întrupat de la Duhul Sfânt şi din Fecioara Maria" 
       	 "şi S-a făcut om."
       	 "Şi S-a răstignit pentru noi în zilele lui Ponţiu Pilat" 
       	 "şi a pătimit şi S-a îngropat."
       	 "Şi a înviat a treia zi, după Scripturi."
       	 "Şi S-a înălțat la ceruri şi şade de-a dreapta Tatălui."
       	 "Şi iarăşi va să vină cu slavă, să judece viii şi morţii," 
          "a Cărui împărăţie nu va avea sfârşit."
          "Şi întru Duhul Sfânt, Domnul de viaţă Făcătorul, Care din Tatăl purcede," 
          "Cel ce împreună cu Tatăl şi cu Fiul este închinat şi slăvit," 
          "Care a grăit prin prooroci."
          "Întru una, sfântă, sobornicească şi apostolească Biserică."
          "Mărturisesc un botez spre iertarea păcatelor."
          "Aştept învierea morţilor."
          "Şi viaţa veacului ce va să fie."
          "Amin!"
          }
    }
 }

}